# -*- coding: utf-8 -*-
"""
Created on Fri Jan  6 11:19:59 2023

@author: pwiechen
"""
#%%
import numpy as np
import os
import pandas as pd
import matplotlib.pyplot as plt
import matplotlib      
from datetime import datetime
import netCDF4 as nc4
from scipy.ndimage import uniform_filter1d
from scipy import interpolate

import scipy.signal

dir_path = os.path.dirname(os.path.abspath(__file__))
os.chdir(dir_path)

print(dir_path)
g = 9.81
rho = 1025


#%% Important times

t_b_experiment = datetime(2021,11,9,0,0,0).timestamp()
t_e_experiment = datetime(2021,12,16,0,0,0).timestamp()

#%% Import datasets

ossi_pres_netcdf = nc4.Dataset(r'../20211106_1000_20211108_1300_ossi.nc','r')

ossi_z = ossi_pres_netcdf['z'][:]
ossi_ap = ossi_pres_netcdf['p_1'][:]
ossi_time = np.round(ossi_pres_netcdf['time'][:],4)
ossi_pres_raw = ossi_pres_netcdf['p_1'][:]
ossi_pres = np.interp(ossi_time, ossi_time[~np.isnan(ossi_pres_raw)],ossi_pres_raw[~np.isnan(ossi_pres_raw)])
ap = ossi_pres_netcdf['ap'][:]

ossi_pres_netcdf.close()
#%% Load Rijkswaterstaat Data

eta_HvH_SCHE_RWS = pd.read_csv(r'../../../Supplementary data/dataset_eta_HvH_SCHE_RWS.csv',index_col=0,parse_dates=['time'])  # Water level at Hoek van Holland and Scheveningen, and estimate of water level at field site
eta_HvH_SCHE_RWS['time_unix'] = pd.to_numeric(eta_HvH_SCHE_RWS['time'])/10**9 - 3600 # Conversion to winter time for field site

air_pressure_HvH_Voor_KNMI = pd.read_csv(r'../../../Supplementary data/dataset_air_pressure_HvH_Voorschoten_KNMI.csv',index_col=0,parse_dates=['time']) # Air pressure at Hoek van Holland and Voorschoten
air_pressure_HvH_Voor_KNMI['pressure_sand_engine'] = 0.5*(air_pressure_HvH_Voor_KNMI['pressure_HvH']+air_pressure_HvH_Voor_KNMI['pressure_voorschoten']) # Air pressure estimate at field site
air_pressure_HvH_Voor_KNMI['time_unix'] = pd.to_numeric(air_pressure_HvH_Voor_KNMI['time'])/10**9 - 3600 # Conversion to winter time for field site

#%% Identify timeslots for air pressure calibration

minimal_emergence = 0.50 # OSSI should be minimally 75 cm above the mean water level
t_cal_b = datetime(2021,11,6,21,0,0).timestamp()
t_cal_e = datetime(2021,11,7,0,0,0).timestamp()
window_size = 10*60*10 #60 minute window for moving average

ossi_eta_rws = np.interp(ossi_time, eta_HvH_SCHE_RWS['time_unix'], eta_HvH_SCHE_RWS['eta_se_estimate_act'])
ossi_ap[np.where(ossi_eta_rws > ossi_z - minimal_emergence)[0]] = np.nan
ossi_ap[np.where(ossi_time < t_cal_b)[0]] = np.nan
ossi_ap[np.where(ossi_time > t_cal_e)[0]] = np.nan

ossi_time_cal = ossi_time[np.where(ossi_time >= t_cal_b)[0][0]:np.where(ossi_time > t_cal_e)[0][0]]
ossi_ap_cal = ossi_ap[np.where(ossi_time >= t_cal_b)[0][0]:np.where(ossi_time > t_cal_e)[0][0]]
ap_cal = ap[np.where(ossi_time >= t_cal_b)[0][0]:np.where(ossi_time > t_cal_e)[0][0]]

offset = uniform_filter1d(ap_cal - np.interp(ossi_time_cal, ossi_time_cal[~np.isnan(ossi_ap_cal)], ossi_ap_cal[~np.isnan(ossi_ap_cal)]), size=window_size)
ossi_ap_cal[np.where(np.abs(ap_cal - (ossi_ap_cal + offset)) > 500)[0]] = np.nan

offset_final = uniform_filter1d(ap_cal - np.interp(ossi_time_cal, ossi_time_cal[~np.isnan(ossi_ap_cal)], ossi_ap_cal[~np.isnan(ossi_ap_cal)]), size=window_size)
offset_final[np.isnan(ossi_ap_cal)] = np.nan
print('Total offset: ',np.mean(offset_final[~np.isnan(offset_final)]))

#%% Final figure

figsize_tot = (4.7747*2, 4.7747*9/5)
fig, (ax1, ax2, ax3) = plt.subplots(nrows=3, sharex=True, figsize=figsize_tot)

ax1.plot(pd.to_datetime(ossi_time+3600, unit='s'), ossi_pres, label='recorded pressure OSSI')
ax1.plot(pd.to_datetime(ossi_time+3600, unit='s'), ap, label='recorded air pressure at HvH')
ax1.plot(pd.to_datetime(ossi_time_cal+3600, unit='s'), ossi_ap_cal + offset_final, label='assumed OSSI air pressure')
ax1.set(ylabel='Pressure [Pa]')

ax1.legend(loc='lower left')
ax1.grid()

ax2.plot(pd.to_datetime(ossi_time+3600, unit='s'), ossi_z + uniform_filter1d((ossi_pres + np.mean(offset_final[~np.isnan(offset_final)]) - ap)/(rho*g), size=window_size), label='eta OSSI')
ax2.plot(pd.to_datetime(ossi_time+3600, unit='s'), ossi_eta_rws, label='recorded eta RWS')
ax2.legend(loc='lower left')
ax2.grid()
ax2.set(ylabel='Elevation [m]')

ax3.plot(pd.to_datetime(ossi_time+3600, unit='s'),ap - ossi_ap, label='Offset OSSI for dry points')
ax3.plot(pd.to_datetime(ossi_time_cal+3600, unit='s'),offset_final, label='Offset OSSI interpolated')

ax3.legend(loc='lower left')
ax3.grid()
ax3.set(ylabel='Pressure [Pa]', xlabel='Date [MM-DD HH]')


# %%
